-- CONFIG
local vuf = {}
vuf.colors    = true
vuf.rest      = true
vuf.lvl       = false
vuf.lvlmax    = true   
vuf.combat    = true
vuf.rcolor    = true   
vuf.dark      = true
vuf.frameRgb  = { 0.4, 0.4, 0.4, 1 }

-- CLASS ICON TOGGLES
vuf.ci         = false
vuf.classIcons = {
    ["DRUID"]   = false,
    ["HUNTER"]  = false,
    ["MAGE"]    = false,
    ["PALADIN"] = true,
    ["PRIEST"]  = false,
    ["ROGUE"]   = false,
    ["SHAMAN"]  = false,
    ["WARLOCK"] = false,
    ["WARRIOR"] = true,
}

---------------------------------------------------------
-- CORE FUNCTIONS
---------------------------------------------------------

-- CLASS COLORS
if vuf.colors then
    local function applyColor(s, unit)
        if UnitIsPlayer(unit) and unit == s.unit then
            local _, class = UnitClass(unit)
            local c = (CUSTOM_CLASS_COLORS or RAID_CLASS_COLORS)[class]
            if c then s:SetStatusBarColor(c.r, c.g, c.b) end
        end
    end
    hooksecurefunc("UnitFrameHealthBar_Update", applyColor)
    hooksecurefunc("HealthBar_OnValueChanged", function(self) applyColor(self, self.unit) end)
end

-- SHARED PLAYER FRAME UPDATES (Rest, Combat, Level)
hooksecurefunc("PlayerFrame_UpdateStatus", function()
    -- Level (Updated for TBC Level 70)
    local maxLevel = GetMaxPlayerLevel() -- Dynamically gets 70
    if vuf.lvl or (vuf.lvlmax and UnitLevel("player") == maxLevel) then
        PlayerFrameTexture:SetTexture("Interface\\TargetingFrame\\UI-TargetingFrame-NoLevel")
        PlayerLevelText:Hide()
    end
    -- Rest
    if vuf.rest and IsResting() then
        PlayerStatusTexture:Hide()
        PlayerRestGlow:Hide()
        PlayerStatusGlow:Hide()
        PlayerRestIcon:Hide()
    end
    -- Combat
    if vuf.combat and PlayerFrame.inCombat then
        PlayerStatusTexture:Hide()
        PlayerAttackGlow:Hide()
        PlayerStatusGlow:Hide()
    end
end)

-- TARGET REACTION (FORCED FOR TBC 2.5.5)
if vuf.rcolor then
    if TargetFrameNameBackground then
        -- Force the color immediately
        TargetFrameNameBackground:SetVertexColor(0, 0, 0, 0.1)
        
        -- Prevent the game from changing it back
        hooksecurefunc(TargetFrameNameBackground, "SetVertexColor", function(self, r, g, b, a)
            -- If the alpha isn't 0.5, it means the game just tried to overwrite us
            if a ~= 0.1 then
                self:SetVertexColor(0, 0, 0, 0.1)
            end
        end)
    end
end
if TargetFrameToTNameBackground then
    TargetFrameToTNameBackground:SetVertexColor(0, 0, 0, 0.1)
    hooksecurefunc(TargetFrameToTNameBackground, "SetVertexColor", function(self, r, g, b, a)
        if a ~= 0.5 then self:SetVertexColor(0, 0, 0, 0.1) end
    end)
end

-- DARK FRAMES
if vuf.dark then
    local frames = {
        PlayerFrameTexture, 
        TargetFrameTextureFrameTexture, 
        TargetFrameToTTextureFrameTexture, 
        PetFrameTexture,
        -- Focus Frames (TBC)
        FocusFrameTextureFrameTexture,
        FocusFrameToTTextureFrameTexture,
        -- Timers
        MirrorTimer1Border, MirrorTimer2Border, MirrorTimer3Border,
    }

    -- Add Party frames safely
    for i=1, 4 do
        table.insert(frames, _G["PartyMemberFrame"..i.."Texture"])
    end

    -- Apply color to the list
    for _, f in ipairs(frames) do
        if f then f:SetVertexColor(unpack(vuf.frameRgb)) end
    end
end

-- CLASS ICONS
local _, myClass = UnitClass("player")
if vuf.ci or vuf.classIcons[myClass] then
    hooksecurefunc("UnitFramePortrait_Update", function(self)
        local portrait = self.portrait or (self.unit == "targettarget" and _G[self:GetName().."Portrait"])
        if portrait and self.unit then
            if UnitIsPlayer(self.unit) then
                local _, class = UnitClass(self.unit)
                local t = CLASS_ICON_TCOORDS[class]
                if t then
                    portrait:SetTexture("Interface\\TargetingFrame\\UI-Classes-Circles")
                    portrait:SetTexCoord(unpack(t))
                end
            else
                portrait:SetTexCoord(0, 1, 0, 1)
            end
        end
    end)
end