-- CONFIG
local vuf = {}
vuf.scale     = 1.00   -- Set frame scale
vuf.position  = true   -- Set frame position
vuf.player    = { "CENTER", UIParent, "CENTER", -280, -180 }  
vuf.target    = { "CENTER", UIParent, "CENTER", 280, -180 }   
vuf.texture   = true   -- Custom texture for health/power bars
vuf.colors    = true   -- Class colors for health bar
vuf.rest      = true   -- Turn off rest flashing and rest icon
vuf.lvl       = false  -- Hide player level always
vuf.lvlmax    = true   -- Hide player level if level 60
vuf.combat    = true   -- Turn off combat flashing
vuf.combati   = false  -- Hide combat icon
vuf.rcolor    = true   -- Remove reaction color from target frame
vuf.dark      = true   -- Make frames darker
vuf.frameRgb  = { 0.4, 0.4, 0.4, 1 }  -- Set frame darkness (R, G, B, Alpha)

-- CLASS ICON TOGGLES
vuf.ci        = false  -- If true, shows class icons for EVERYONE regardless of your class
vuf.classIcons = {
    ["DRUID"]   = false,
    ["HUNTER"]  = false,
    ["MAGE"]    = false,
    ["PALADIN"] = true,
    ["PRIEST"]  = false,
    ["ROGUE"]   = false,
    ["SHAMAN"]  = false,
    ["WARLOCK"] = false,
    ["WARRIOR"] = true,
}

---------------------------------------------------------
-- CORE FUNCTIONS
---------------------------------------------------------

-- SCALE & POSITION
PlayerFrame:SetScale(vuf.scale)
TargetFrame:SetScale(vuf.scale)
CastingBarFrame:SetScale(vuf.scale)

if vuf.position then
    local f = CreateFrame("Frame")
    f:RegisterEvent("PLAYER_ENTERING_WORLD")
    f:SetScript("OnEvent", function()
        PlayerFrame:ClearAllPoints()
        PlayerFrame:SetPoint(unpack(vuf.player))
        PlayerFrame:SetUserPlaced(true)
        TargetFrame:ClearAllPoints()
        TargetFrame:SetPoint(unpack(vuf.target))
        TargetFrame:SetUserPlaced(true)
    end)
end

-- CUSTOM TEXTURE
if vuf.texture then
    local NEW_TEXTURE = "Interface\\Addons\\vUF\\Minimalist" 
    local bars = {
        PlayerFrameHealthBar, PlayerFrameManaBar,
        TargetFrameHealthBar, TargetFrameManaBar,
        PetFrameHealthBar, PetFrameManaBar,
    }
    for i=1, 4 do
        table.insert(bars, _G["PartyMemberFrame"..i.."HealthBar"])
        table.insert(bars, _G["PartyMemberFrame"..i.."ManaBar"])
    end

    for _, bar in ipairs(bars) do
        if bar then
            bar:SetStatusBarTexture(NEW_TEXTURE)
            bar:GetStatusBarTexture():SetHorizTile(false)
        end
    end
end

-- CLASS COLORS
if vuf.colors then
    local function applyColor(s, unit)
        if UnitIsPlayer(unit) and unit == s.unit then
            local _, class = UnitClass(unit)
            local c = (CUSTOM_CLASS_COLORS or RAID_CLASS_COLORS)[class]
            if c then s:SetStatusBarColor(c.r, c.g, c.b) end
        end
    end
    hooksecurefunc("UnitFrameHealthBar_Update", applyColor)
    hooksecurefunc("HealthBar_OnValueChanged", function(self) applyColor(self, self.unit) end)
end

-- SHARED PLAYER FRAME UPDATES (Rest, Combat, Level)
hooksecurefunc("PlayerFrame_UpdateStatus", function()
    -- Level
    if vuf.lvl or (vuf.lvlmax and UnitLevel("player") == 60) then
        PlayerFrameTexture:SetTexture("Interface\\TargetingFrame\\UI-TargetingFrame-NoLevel")
        PlayerLevelText:Hide()
    end
    -- Rest
    if vuf.rest and IsResting() then
        PlayerStatusTexture:Hide()
        PlayerRestGlow:Hide()
        PlayerStatusGlow:Hide()
        PlayerRestIcon:Hide()
    end
    -- Combat
    if vuf.combat and PlayerFrame.inCombat then
        PlayerStatusTexture:Hide()
        PlayerAttackGlow:Hide()
        PlayerStatusGlow:Hide()
    end
    if vuf.combati then
        PlayerAttackIcon:Hide()
        PlayerAttackBackground:Hide()
    end
end)

-- TARGET REACTION
if vuf.rcolor then
    hooksecurefunc("TargetFrame_CheckFaction", function(self)
        if self.nameBackground then
            self.nameBackground:SetVertexColor(0, 0, 0, 0.5)
        end
    end)
end

-- DARK FRAMES
if vuf.dark then
    local frames = {
        PlayerFrameTexture, TargetFrameTextureFrameTexture, 
        TargetFrameToTTextureFrameTexture, PetFrameTexture,
        PartyMemberFrame1Texture, PartyMemberFrame2Texture, 
        PartyMemberFrame3Texture, PartyMemberFrame4Texture,
        CastingBarFrame.Border, TargetFrameSpellBar.Border,
        MirrorTimer1Border, MirrorTimer2Border, MirrorTimer3Border,
    }
    for _, f in ipairs(frames) do
        if f then f:SetVertexColor(unpack(vuf.frameRgb)) end
    end
end

-- CLASS ICONS logic
local _, myClass = UnitClass("player")
if vuf.ci or vuf.classIcons[myClass] then
    hooksecurefunc("UnitFramePortrait_Update", function(self)
        -- Identify the portrait texture object
        -- ToT frames often use self.portrait, but we need to ensure it exists
        local portrait = self.portrait or (self.unit == "targettarget" and _G[self:GetName().."Portrait"])
        
        if portrait and self.unit then
            if UnitIsPlayer(self.unit) then
                local _, class = UnitClass(self.unit)
                local t = CLASS_ICON_TCOORDS[class]
                if t then
                    portrait:SetTexture("Interface\\TargetingFrame\\UI-Classes-Circles")
                    portrait:SetTexCoord(unpack(t))
                end
            else
                -- Reset to default 3D/2D portrait for NPCs
                portrait:SetTexCoord(0, 1, 0, 1)
            end
        end
    end)
end