-- CONFIG
local vmm = {
    scale    = 1.20, -- Set frame scale
    position = true, -- Set frame position
    coord    = { "TOPRIGHT", "UIParent", "TOPRIGHT", -8, -18 }, -- Set frame location
    lfg      = true, -- Hide LFG eye in Fresh Classic - Code from Leatrix Plus
    gtt      = true, -- Hide game time texture
    mmb      = false, -- Hide minimap border top, zone text and toggle button
    track    = true, -- Hide tracking frame
    zoom     = true, -- Hide zoom in/out buttons
    mouse    = true, -- Mouse wheel zoom
    dark     = true, -- Make frames darker
    frameRgb = { 0.5, 0.5, 0.5, 1 } -- Set frame darkness
}

-- SCALE
MinimapCluster:SetScale(vmm.scale)

-- POSITIONING
if vmm.position then
    local posFrame = CreateFrame("Frame")
    posFrame:RegisterEvent("PLAYER_ENTERING_WORLD")
    posFrame:SetScript("OnEvent", function()
        MinimapCluster:ClearAllPoints()
        MinimapCluster:SetPoint(unpack(vmm.coord))
        -- Allow the frame to stay where placed
        MinimapCluster:SetMovable(true)
        MinimapCluster:SetUserPlaced(true)
    end)
end

-- LFG EYE (Fresh Classic Compatibility)
if vmm.lfg then
    EventUtil.ContinueOnAddOnLoaded("Blizzard_GroupFinder_VanillaStyle", function()
        local function SetLFGButton()
            if C_LFGList.HasActiveEntryInfo() then
                LFGMinimapFrame:Show()
            else
                LFGMinimapFrame:Hide()
            end
        end
        LFGMinimapFrame:HookScript("OnEvent", SetLFGButton)
        SetLFGButton()
    end)
end

-- HIDE UI ELEMENTS
if vmm.gtt then GameTimeTexture:Hide() end

if vmm.mmb then
    MinimapBorderTop:Hide()
    MinimapZoneText:Hide()
    MinimapToggleButton:Hide()
end

if vmm.track then
    -- Handles the classic tracking button
    MiniMapTracking:Hide()
end

if vmm.zoom then
    MinimapZoomIn:Hide()
    MinimapZoomOut:Hide()
end

-- MOUSE WHEEL ZOOM
if vmm.mouse then
    Minimap:EnableMouseWheel(true)
    Minimap:SetScript("OnMouseWheel", function(self, delta)
        if delta > 0 then
            Minimap_ZoomIn()
        else
            Minimap_ZoomOut()
        end
    end)
end

-- DARKER BORDERS (Aggressive Hook Method)
if vmm.dark then
    local borders = {
        "MinimapBorder",
        "MinimapBorderTop",
        "MiniMapLFGFrameBorder",
        "MiniMapMailBorder",
        "MiniMapTrackingButtonBorder",
        "MiniMapBattlefieldBorder",
        "QueueStatusMinimapButtonBorder",
        "MiniMapTrackingBorder",
    }

    for _, frameName in ipairs(borders) do
        local f = _G[frameName]
        if f then
            -- Set initial color
            f:SetVertexColor(unpack(vmm.frameRgb))
            
            -- Prevent the game from changing it back (Hooks the function)
            hooksecurefunc(f, "SetVertexColor", function(self, r, g, b)
                local nr, ng, nb = unpack(vmm.frameRgb)
                if r ~= nr or g ~= ng or b ~= nb then
                    self:SetVertexColor(nr, ng, nb)
                end
            end)
        end
    end
end