-----------------------------
-- CONFIGURATION & FONT
-----------------------------
local CHAT_FONT = STANDARD_TEXT_FONT
--local CHAT_FONT = "Interface\\Addons\\vChat\\font.ttf"

for i = 1, NUM_CHAT_WINDOWS do
    local chat = _G["ChatFrame"..i]
    if chat then
        local _, size = chat:GetFont()
        chat:SetFont(CHAT_FONT, size, "OUTLINE")
        chat:SetShadowOffset(1, -1)
        chat:SetShadowColor(0, 0, 0, 0.7)
    end
end

-----------------------------
-- THE MOTD KILLER (Nuclear Option)
-----------------------------
-- We empty the global strings that Blizzard uses to build the MOTD message.
_G.GUILD_MOTD_TEMPLATE = ""
_G.CHAT_GUILD_MOTD_GET = ""

-----------------------------
-- FUNCTIONS
-----------------------------

local function SkinChat(self)
    if not self or self.vChatSkinned then return end
    local name = self:GetName()
    
    self:SetClampedToScreen(false) 
    self:SetMovable(true)
    self:SetUserPlaced(true)
    self:SetClampRectInsets(0, 0, 0, 0)
    self:SetFading(true)

    local bf = _G[name.."ButtonFrame"]
    if bf then
        bf:HookScript("OnShow", bf.Hide)
        bf:Hide()
    end

    local eb = _G[name.."EditBox"]
    if eb then
        eb:SetAltArrowKeyMode(false)
        local texs = {"Left", "Mid", "Right", "FocusLeft", "FocusMid", "FocusRight"}
        for _, tex in pairs(texs) do
            local gtex = _G[name.."EditBox"..tex]
            if gtex then gtex:Hide() end
        end

        eb:ClearAllPoints()
        if name == "ChatFrame2" then
            eb:SetPoint("BOTTOMLEFT", self, "TOPLEFT", 0, 46)
            eb:SetPoint("BOTTOMRIGHT", self, "TOPRIGHT", 0, 46)
        else
            eb:SetPoint("BOTTOMLEFT", self, "TOPLEFT", 0, 22)
            eb:SetPoint("BOTTOMRIGHT", self, "TOPRIGHT", 0, 22)
        end
    end
    self.vChatSkinned = true
end

local function OnMOuseScroll(self, dir)
    if dir > 0 then
        if IsShiftKeyDown() then self:ScrollToTop() else self:ScrollUp() end
    else
        if IsShiftKeyDown() then self:ScrollToBottom() else self:ScrollDown() end
    end
end

local DefaultSetItemRef = SetItemRef
SetItemRef = function(link, text, button, chatFrame)
    local type, value = link:match("(%a+):(.+)")
    if IsAltKeyDown() and type == "player" then
        local name = value:match("([^:]+)")
        if name then InviteUnit(name) end
    elseif type == "url" then
        local eb = LAST_ACTIVE_CHAT_EDIT_BOX or ChatFrame1EditBox
        if eb then
            eb:SetText(value)
            eb:SetFocus()
            eb:HighlightText()
            if not eb:IsShown() then eb:Show() end
        end
    else
        return DefaultSetItemRef(link, text, button, chatFrame)
    end
end

local function NewAddMessage(self, text, ...)
    if type(text) == "string" and text ~= "" then
        text = text:gsub("|Hplayer:(.-)|h%[(.-)%]|h", "|Hplayer:%1|h%2|h")
        text = text:gsub('|h%[(%d+)%. .-%]|h', '|h%1|h')
        text = text:gsub('([wWhH][wWtT][wWtT][%.pP]%S+[^%p%s])', '|cffffffff|Hurl:%1|h[%1]|h|r')
    end
    -- Prevent printing empty strings (from the MOTD killer)
    if text == "" then return end
    return self.DefaultAddMessage(self, text, ...)
end

-----------------------------
-- MESSAGE FILTERS (Suppression)
-----------------------------

local function GeneralMessageFilter(self, event, msg, ...)
    if event == "CHAT_MSG_GUILD_MOTD" then return true end
    if event == "CHAT_MSG_CHANNEL_NOTICE" then
        if msg == "YOU_JOINED" or msg == "YOU_LEFT" or msg == "YOU_CHANGED" then
            return true
        end
    end
    if event == "CHAT_MSG_SYSTEM" then
        if msg:find("Left channel") or msg:find("Joined channel") then
            return true
        end
    end
    return false
end

ChatFrame_AddMessageEventFilter("CHAT_MSG_CHANNEL_NOTICE", GeneralMessageFilter)
ChatFrame_AddMessageEventFilter("CHAT_MSG_SYSTEM", GeneralMessageFilter)
ChatFrame_AddMessageEventFilter("CHAT_MSG_GUILD_MOTD", GeneralMessageFilter)

-----------------------------
-- CHAT GLOBALS & HEADERS
-----------------------------

CHAT_FONT_HEIGHTS = {10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20}
CHAT_TAB_HIDE_DELAY = 1
CHAT_FRAME_TAB_NORMAL_MOUSEOVER_ALPHA = 1
CHAT_FRAME_TAB_NORMAL_NOMOUSE_ALPHA = 0
CHAT_FRAME_TAB_SELECTED_MOUSEOVER_ALPHA = 1
CHAT_FRAME_TAB_SELECTED_NOMOUSE_ALPHA = 0

PLAYER_NAME_IN_SAY = "%s"
PLAYER_NAME_IN_YELL = "%s"
CHAT_WHISPER_GET            = "From %s "
CHAT_WHISPER_INFORM_GET       = "To %s "
CHAT_BN_WHISPER_GET           = "From %s "
CHAT_BN_WHISPER_INFORM_GET    = "To %s "
CHAT_YELL_GET                 = "%s "
CHAT_SAY_GET                  = "%s "

CHAT_GUILD_GET                = "|Hchannel:Guild|hG|h %s: "
CHAT_PARTY_GET                = "|Hchannel:Party|hP|h %s: "
CHAT_RAID_GET                 = "|Hchannel:Raid|hR|h %s: "
CHAT_RAID_WARNING_GET         = "|Hchannel:RaidWarning|hRW|h %s: "

YOU_LOOT_MONEY_GUILD = YOU_LOOT_MONEY
LOOT_MONEY_SPLIT_GUILD = LOOT_MONEY_SPLIT

if BNToastFrame then
    BNToastFrame:SetClampedToScreen(true)
    BNToastFrame:SetClampRectInsets(-15,15,15,-15)
end

ChatFrameMenuButton:HookScript("OnShow", ChatFrameMenuButton.Hide)
ChatFrameMenuButton:Hide()
if ChatFrameChannelButton then
    ChatFrameChannelButton:HookScript("OnShow", ChatFrameChannelButton.Hide)
    ChatFrameChannelButton:Hide()
end

-----------------------------
-- INITIALIZATION & POSITIONING
-----------------------------
--local function ForceChatPosition()
--    ChatFrame1:ClearAllPoints()
--    ChatFrame1:SetPoint("BOTTOMLEFT", UIParent, "BOTTOMLEFT", 6, 6)
--    FCF_SavePositionAndDimensions(ChatFrame1)
--end

local loader = CreateFrame("Frame")
loader:RegisterEvent("PLAYER_ENTERING_WORLD")
loader:SetScript("OnEvent", function(self, event)
    for i = 1, NUM_CHAT_WINDOWS do
        local chatframe = _G["ChatFrame"..i]
        if chatframe then
            SkinChat(chatframe)
            if (i ~= 2) and not chatframe.DefaultAddMessage then
                chatframe.DefaultAddMessage = chatframe.AddMessage
                chatframe.AddMessage = NewAddMessage
            end
            chatframe:SetScript("OnMouseWheel", OnMOuseScroll)
        end
    end
    
--    ForceChatPosition()
    self:UnregisterEvent("PLAYER_ENTERING_WORLD")
end)

hooksecurefunc("FCF_OpenTemporaryWindow", function()
    for _, name in next, CHAT_FRAMES do
        local frame = _G[name]
        if frame and frame.isTemporary then
            SkinChat(frame)
        end
    end
end)

-----------------------------
-- KEYBIND FUNCTIONS
-----------------------------

function vChat_OpenGuildChat() ChatFrame_OpenChat("/g ", ChatFrame1) end
function vChat_OpenPartyChat() ChatFrame_OpenChat("/p ", ChatFrame1) end
function vChat_OpenSayChat() ChatFrame_OpenChat("/s ", ChatFrame1) end
function vChat_OpenRaidChat() ChatFrame_OpenChat("/ra ", ChatFrame1) end